/*
 * Decompiled with CFR 0.152.
 */
package rpgboss.player;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import rpgboss.lib.ThreadChecked$class;
import rpgboss.lib.Utils$;
import rpgboss.model.Animation;
import rpgboss.model.AnimationSound;
import rpgboss.model.Constants$;
import rpgboss.model.EntitySpec$;
import rpgboss.model.MapLoc;
import rpgboss.model.MapLoc$;
import rpgboss.model.Project;
import rpgboss.model.RandomEncounter;
import rpgboss.model.RandomEncounterSettings;
import rpgboss.model.SoundSpec;
import rpgboss.model.Transitions$;
import rpgboss.model.event.RpgEvent;
import rpgboss.model.resource.Autotile;
import rpgboss.model.resource.MusicPlayer;
import rpgboss.model.resource.RpgAssetManager;
import rpgboss.model.resource.RpgMap;
import rpgboss.model.resource.RpgMap$;
import rpgboss.model.resource.RpgMapMetadata;
import rpgboss.model.resource.Tileset;
import rpgboss.model.resource.Tileset$;
import rpgboss.player.EntityInfo;
import rpgboss.player.EntityInfo$;
import rpgboss.player.HasScriptConstants;
import rpgboss.player.HasScriptConstants$class;
import rpgboss.player.InputMultiplexer;
import rpgboss.player.MapAndAssets;
import rpgboss.player.MapCamera;
import rpgboss.player.MapScreen$;
import rpgboss.player.MapScreen$$anonfun$renderMap$1$;
import rpgboss.player.MapScreen$$anonfun$renderMap$1$$anonfun$apply$2$;
import rpgboss.player.RpgGame;
import rpgboss.player.RpgScreen$class;
import rpgboss.player.RpgScreenWithGame;
import rpgboss.player.RpgScreenWithGame$class;
import rpgboss.player.ScriptHookManager;
import rpgboss.player.ScriptInterface;
import rpgboss.player.ScriptThreadFactory;
import rpgboss.player.ShakeManager;
import rpgboss.player.WindowManager;
import rpgboss.player.entity.AnimationPlayer;
import rpgboss.player.entity.AnimationTarget;
import rpgboss.player.entity.Entity;
import rpgboss.player.entity.EntityMove;
import rpgboss.player.entity.EventEntity;
import rpgboss.player.entity.PlayerEntity;
import rpgboss.player.entity.VehicleEntity;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.math.Ordering$Float$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.NonLocalReturnControl$mcF$sp;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t%b\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\"T1q'\u000e\u0014X-\u001a8\u000b\u0005\r!\u0011A\u00029mCf,'OC\u0001\u0006\u0003\u001d\u0011\bo\u001a2pgN\u001c\u0001a\u0005\u0003\u0001\u0011A!\u0002CA\u0005\u000f\u001b\u0005Q!BA\u0006\r\u0003\u0011a\u0017M\\4\u000b\u00035\tAA[1wC&\u0011qB\u0003\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005E\u0011R\"\u0001\u0002\n\u0005M\u0011!!\u0005*qON\u001b'/Z3o/&$\bnR1nKB\u0011\u0011#F\u0005\u0003-\t\u0011!\u0003S1t'\u000e\u0014\u0018\u000e\u001d;D_:\u001cH/\u00198ug\"A\u0001\u0004\u0001BC\u0002\u0013\u0005\u0011$\u0001\u0003hC6,W#\u0001\u000e\u0011\u0005EY\u0012B\u0001\u000f\u0003\u0005\u001d\u0011\u0006oZ$b[\u0016D\u0001B\b\u0001\u0003\u0002\u0003\u0006IAG\u0001\u0006O\u0006lW\r\t\u0005\u0006A\u0001!\t!I\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\t\u001a\u0003CA\t\u0001\u0011\u0015Ar\u00041\u0001\u001b\u0011\u001d)\u0003A1A\u0005\u0002\u0019\n1b]2sSB$\bj\\8lgV\tq\u0005\u0005\u0002\u0012Q%\u0011\u0011F\u0001\u0002\u0012'\u000e\u0014\u0018\u000e\u001d;I_>\\W*\u00198bO\u0016\u0014\bBB\u0016\u0001A\u0003%q%\u0001\u0007tGJL\u0007\u000f\u001e%p_.\u001c\b\u0005C\u0004.\u0001\u0001\u0007I\u0011\u0001\u0018\u0002\u0019M\u001c'/Z3o/RKG.Z:\u0016\u0003=\u0002\"\u0001M\u001a\u000e\u0003ER\u0011AM\u0001\u0006g\u000e\fG.Y\u0005\u0003iE\u0012QA\u00127pCRDqA\u000e\u0001A\u0002\u0013\u0005q'\u0001\ttGJ,WM\\,US2,7o\u0018\u0013fcR\u0011\u0001h\u000f\t\u0003aeJ!AO\u0019\u0003\tUs\u0017\u000e\u001e\u0005\byU\n\t\u00111\u00010\u0003\rAH%\r\u0005\u0007}\u0001\u0001\u000b\u0015B\u0018\u0002\u001bM\u001c'/Z3o/RKG.Z:!\u0011\u001d\u0001\u0005\u00011A\u0005\u00029\nAb]2sK\u0016t\u0007\nV5mKNDqA\u0011\u0001A\u0002\u0013\u00051)\u0001\ttGJ,WM\u001c%US2,7o\u0018\u0013fcR\u0011\u0001\b\u0012\u0005\by\u0005\u000b\t\u00111\u00010\u0011\u00191\u0005\u0001)Q\u0005_\u0005i1o\u0019:fK:DE+\u001b7fg\u0002Bq\u0001\u0013\u0001C\u0002\u0013\u0005\u0011*\u0001\u0006uS2,7)Y7fe\u0006,\u0012A\u0013\t\u0003\u0017Rk\u0011\u0001\u0014\u0006\u0003\u001b:\u000b\u0001b\u001a:ba\"L7m\u001d\u0006\u0003\u001fB\u000b1a\u001a3y\u0015\t\t&+\u0001\u0005cC\u0012dwnZ5d\u0015\u0005\u0019\u0016aA2p[&\u0011Q\u000b\u0014\u0002\u0013\u001fJ$\bn\\4sCBD\u0017nY\"b[\u0016\u0014\u0018\r\u0003\u0004X\u0001\u0001\u0006IAS\u0001\fi&dWmQ1nKJ\f\u0007\u0005C\u0004Z\u0001\u0001\u0007I\u0011\u0001.\u0002%5\f\u0007/\u00118e\u0003N\u001cX\r^:PaRLwN\\\u000b\u00027B\u0019\u0001\u0007\u00180\n\u0005u\u000b$AB(qi&|g\u000e\u0005\u0002\u0012?&\u0011\u0001M\u0001\u0002\r\u001b\u0006\u0004\u0018I\u001c3BgN,Go\u001d\u0005\bE\u0002\u0001\r\u0011\"\u0001d\u0003Yi\u0017\r]!oI\u0006\u001b8/\u001a;t\u001fB$\u0018n\u001c8`I\u0015\fHC\u0001\u001de\u0011\u001da\u0014-!AA\u0002mCaA\u001a\u0001!B\u0013Y\u0016aE7ba\u0006sG-Q:tKR\u001cx\n\u001d;j_:\u0004\u0003\"\u00025\u0001\t\u0003I\u0017aB7ba:\u000bW.Z\u000b\u0002UB\u0019\u0001\u0007X6\u0011\u00051|gB\u0001\u0019n\u0013\tq\u0017'\u0001\u0004Qe\u0016$WMZ\u0005\u0003aF\u0014aa\u0015;sS:<'B\u000182\u0011\u0015\u0019\b\u0001\"\u0001u\u00031\u0001H.Y=fe\u0016sG/\u001b;z+\u0005)\bC\u0001<z\u001b\u00059(B\u0001=\u0003\u0003\u0019)g\u000e^5us&\u0011!p\u001e\u0002\r!2\f\u00170\u001a:F]RLG/\u001f\u0005\u0006y\u0002!\t!`\u0001\u0014O\u0016$\b\u000b\\1zKJ,e\u000e^5us&sgm\u001c\u000b\u0002}B\u0011\u0011c`\u0005\u0004\u0003\u0003\u0011!AC#oi&$\u00180\u00138g_\"9\u0011Q\u0001\u0001\u0005\u0002\u0005\u001d\u0011AC7pm\u0016\u0004F.Y=feRA\u0011\u0011BA\b\u0003'\t9\u0002E\u0002w\u0003\u0017I1!!\u0004x\u0005))e\u000e^5us6{g/\u001a\u0005\b\u0003#\t\u0019\u00011\u00010\u0003\t!\u0007\u0010C\u0004\u0002\u0016\u0005\r\u0001\u0019A\u0018\u0002\u0005\u0011L\b\u0002CA\r\u0003\u0007\u0001\r!a\u0007\u0002\u001d\u00054g-\u001b=ESJ,7\r^5p]B\u0019\u0001'!\b\n\u0007\u0005}\u0011GA\u0004C_>dW-\u00198\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&\u0005IQn\u001c<f\u000bZ,g\u000e\u001e\u000b\u000b\u0003\u0013\t9#!\r\u00024\u0005U\u0002\u0002CA\u0015\u0003C\u0001\r!a\u000b\u0002\u0005%$\u0007c\u0001\u0019\u0002.%\u0019\u0011qF\u0019\u0003\u0007%sG\u000fC\u0004\u0002\u0012\u0005\u0005\u0002\u0019A\u0018\t\u000f\u0005U\u0011\u0011\u0005a\u0001_!A\u0011\u0011DA\u0011\u0001\u0004\tY\u0002C\u0004\u0002:\u0001!\t!a\u000f\u0002\u0013\u001d,G/\u0012<f]RDFcA\u0018\u0002>!A\u0011\u0011FA\u001c\u0001\u0004\tY\u0003C\u0004\u0002B\u0001!\t!a\u0011\u0002\u0013\u001d,G/\u0012<f]RLFcA\u0018\u0002F!A\u0011\u0011FA \u0001\u0004\tY\u0003C\u0004\u0002J\u0001!\t!a\u0013\u0002\u001fM,GoQ1nKJ\fgi\u001c7m_^$2\u0001OA'\u0011!\ty%a\u0012A\u0002\u0005E\u0013\u0001C3oi&$\u00180\u00133\u0011\tAb\u00161\u0006\u0005\n\u0003+\u0002!\u0019!C\u0001\u0003/\naaY1nKJ\fWCAA-!\r\t\u00121L\u0005\u0004\u0003;\u0012!!C'ba\u000e\u000bW.\u001a:b\u0011!\t\t\u0007\u0001Q\u0001\n\u0005e\u0013aB2b[\u0016\u0014\u0018\r\t\u0005\n\u0003K\u0002!\u0019!C\u0001\u0003O\n1\"\u00197m\u000b:$\u0018\u000e^5fgV\u0011\u0011\u0011\u000e\t\t\u0003W\n)(a\u000b\u0002z5\u0011\u0011Q\u000e\u0006\u0005\u0003_\n\t(A\u0004nkR\f'\r\\3\u000b\u0007\u0005M\u0014'\u0001\u0006d_2dWm\u0019;j_:LA!a\u001e\u0002n\t\u0019Q*\u00199\u0011\u0007Y\fY(C\u0002\u0002~]\u0014a!\u00128uSRL\b\u0002CAA\u0001\u0001\u0006I!!\u001b\u0002\u0019\u0005dG.\u00128uSRLWm\u001d\u0011\t\u0013\u0005\u0015\u0005\u00011A\u0005\u0002\u0005\u001d\u0015\u0001F2b[\u0016\u0014\u0018MR8mY><X\rZ#oi&$\u00180\u0006\u0002\u0002\nB!\u0001\u0007XA=\u0011%\ti\t\u0001a\u0001\n\u0003\ty)\u0001\rdC6,'/\u0019$pY2|w/\u001a3F]RLG/_0%KF$2\u0001OAI\u0011%a\u00141RA\u0001\u0002\u0004\tI\t\u0003\u0005\u0002\u0016\u0002\u0001\u000b\u0015BAE\u0003U\u0019\u0017-\\3sC\u001a{G\u000e\\8xK\u0012,e\u000e^5us\u0002Bq!!'\u0001\t\u0003\tY*\u0001\u0007tKR\u0004F.Y=fe2{7\rF\u00029\u0003;C\u0001\"a(\u0002\u0018\u0002\u0007\u0011\u0011U\u0001\u0004Y>\u001c\u0007\u0003BAR\u0003Sk!!!*\u000b\u0007\u0005\u001dF!A\u0003n_\u0012,G.\u0003\u0003\u0002,\u0006\u0015&AB'ba2{7\rC\u0004\u00020\u0002!\t!!-\u0002+A,'o]5tiBc\u0017-_3s\u0019>\u001c\u0017\r^5p]R\t\u0001\bC\u0004\u00026\u0002!\t!a.\u0002'%t7/\u001a:u-\u0016D\u0017n\u00197f\u000b:$\u0018\u000e^=\u0015\u000ba\nI,!0\t\u0011\u0005m\u00161\u0017a\u0001\u0003W\t\u0011B^3iS\u000edW-\u00133\t\u0011\u0005}\u00151\u0017a\u0001\u0003CCq!!1\u0001\t\u0003\t\u0019-A\bva\u0012\fG/Z\"b[\u0016\u0014\u0018\rT8d)\u001dA\u0014QYAe\u0003\u001bDq!a2\u0002@\u0002\u0007q&A\u0003eK2$\u0018\rC\u0004\u0002L\u0006}\u0006\u0019\u00010\u0002\u00195\f\u0007/\u00118e\u0003N\u001cX\r^:\t\u0011\u0005=\u0017q\u0018a\u0001\u00037\t\u0011CZ8sG\u0016\u001cf.\u00199U_\u0016sG/\u001b;z\u0011\u001d\t\u0019\u000e\u0001C\u0001\u0003+\f\u0001\u0002\u001a:boRKG.\u001a\u000b\u0013\u0003/\fi.!<\u0002p\u0006M\u0018q_A~\u0005\u000b\u0011I\u0001E\u00021\u00033L1!a72\u0005\r\te.\u001f\u0005\t\u0003?\f\t\u000e1\u0001\u0002b\u0006)!-\u0019;dQB!\u00111]Au\u001b\t\t)OC\u0002\u0002h2\u000b1a\u001a\u001ae\u0013\u0011\tY/!:\u0003\u0017M\u0003(/\u001b;f\u0005\u0006$8\r\u001b\u0005\b\u0003\u0017\f\t\u000e1\u0001_\u0011\u001d\t\t0!5A\u0002=\nQb\u001e5fe\u0016LenU3d_:$\u0007\u0002CA{\u0003#\u0004\r!a\u000b\u0002\u000bQLG.\u001a-\t\u0011\u0005e\u0018\u0011\u001ba\u0001\u0003W\tQ\u0001^5mKfC\u0001\"!@\u0002R\u0002\u0007\u0011q`\u0001\u0006Ef$X-\r\t\u0004a\t\u0005\u0011b\u0001B\u0002c\t!!)\u001f;f\u0011!\u00119!!5A\u0002\u0005}\u0018!\u00022zi\u0016\u0014\u0004\u0002\u0003B\u0006\u0003#\u0004\r!a@\u0002\u000b\tLH/Z\u001a\t\u000f\t=\u0001\u0001\"\u0001\u0003\u0012\u00051Q\u000f\u001d3bi\u0016$2\u0001\u000fB\n\u0011\u001d\t9M!\u0004A\u0002=BqAa\u0006\u0001\t\u0003\u0011I\"A\u0005sK:$WM]'baR\u0011!1\u0004\t\u0004aqC\u0004b\u0002B\u0010\u0001\u0011\u0005\u0011\u0011W\u0001\u0007e\u0016tG-\u001a:\t\u000f\t\r\u0002\u0001\"\u0011\u00022\u00069A-[:q_N,\u0007b\u0002B\u0014\u0001\u0011\u0005\u0013\u0011W\u0001\u0006e\u0016\u001cX\r\u001e")
public class MapScreen
implements RpgScreenWithGame,
HasScriptConstants {
    private final RpgGame game;
    private final ScriptHookManager scriptHooks;
    private float screenWTiles;
    private float screenHTiles;
    private final OrthographicCamera tileCamera;
    private Option<MapAndAssets> mapAndAssetsOption;
    private final MapCamera camera;
    private final Map<Object, Entity> allEntities;
    private Option<Entity> cameraFollowedEntity;
    private final int LEFT;
    private final int CENTER;
    private final int RIGHT;
    private final String PLAYER_LOC;
    private final String GOLD;
    private final String PLAYER_MOVEMENT_LOCKS;
    private final String EVENTS_ENABLED;
    private final String MENU_ENABLED;
    private final String PARTY;
    private final String INVENTORY_ITEM_IDS;
    private final String INVENTORY_QTYS;
    private final String CHARACTER_NAMES;
    private final String CHARACTER_LEVELS;
    private final String CHARACTER_HPS;
    private final String CHARACTER_MPS;
    private final String CHARACTER_EXPS;
    private final String CHARACTER_ROWS;
    private final int CENTERED;
    private final int NORTH;
    private final int EAST;
    private final int SOUTH;
    private final int WEST;
    private final int NORTHEAST;
    private final int SOUTHEAST;
    private final int SOUTHWEST;
    private final int NORTHWEST;
    private final int FIXED;
    private final int SCALE_SOURCE;
    private final int SCREEN;
    private final int COVER;
    private final int CONTAIN;
    private final ScriptInterface scriptInterface;
    private final ScriptThreadFactory scriptFactory;
    private final InputMultiplexer inputs;
    private final Option<MusicPlayer>[] musics;
    private final SpriteBatch batch;
    private final ShapeRenderer shapeRenderer;
    private final Set<MusicPlayer> oldMusics;
    private final OrthographicCamera screenCamera;
    private final WindowManager windowManager;
    private final ShakeManager shakeManager;
    private AnimationPlayer soundPlayer;
    private AnimationSound animationSound;
    private Animation animation;
    private Thread rpgboss$lib$ThreadChecked$$_boundThread;

    @Override
    public int LEFT() {
        return this.LEFT;
    }

    @Override
    public int CENTER() {
        return this.CENTER;
    }

    @Override
    public int RIGHT() {
        return this.RIGHT;
    }

    @Override
    public String PLAYER_LOC() {
        return this.PLAYER_LOC;
    }

    @Override
    public String GOLD() {
        return this.GOLD;
    }

    @Override
    public String PLAYER_MOVEMENT_LOCKS() {
        return this.PLAYER_MOVEMENT_LOCKS;
    }

    @Override
    public String EVENTS_ENABLED() {
        return this.EVENTS_ENABLED;
    }

    @Override
    public String MENU_ENABLED() {
        return this.MENU_ENABLED;
    }

    @Override
    public String PARTY() {
        return this.PARTY;
    }

    @Override
    public String INVENTORY_ITEM_IDS() {
        return this.INVENTORY_ITEM_IDS;
    }

    @Override
    public String INVENTORY_QTYS() {
        return this.INVENTORY_QTYS;
    }

    @Override
    public String CHARACTER_NAMES() {
        return this.CHARACTER_NAMES;
    }

    @Override
    public String CHARACTER_LEVELS() {
        return this.CHARACTER_LEVELS;
    }

    @Override
    public String CHARACTER_HPS() {
        return this.CHARACTER_HPS;
    }

    @Override
    public String CHARACTER_MPS() {
        return this.CHARACTER_MPS;
    }

    @Override
    public String CHARACTER_EXPS() {
        return this.CHARACTER_EXPS;
    }

    @Override
    public String CHARACTER_ROWS() {
        return this.CHARACTER_ROWS;
    }

    @Override
    public int CENTERED() {
        return this.CENTERED;
    }

    @Override
    public int NORTH() {
        return this.NORTH;
    }

    @Override
    public int EAST() {
        return this.EAST;
    }

    @Override
    public int SOUTH() {
        return this.SOUTH;
    }

    @Override
    public int WEST() {
        return this.WEST;
    }

    @Override
    public int NORTHEAST() {
        return this.NORTHEAST;
    }

    @Override
    public int SOUTHEAST() {
        return this.SOUTHEAST;
    }

    @Override
    public int SOUTHWEST() {
        return this.SOUTHWEST;
    }

    @Override
    public int NORTHWEST() {
        return this.NORTHWEST;
    }

    @Override
    public int FIXED() {
        return this.FIXED;
    }

    @Override
    public int SCALE_SOURCE() {
        return this.SCALE_SOURCE;
    }

    @Override
    public int SCREEN() {
        return this.SCREEN;
    }

    @Override
    public int COVER() {
        return this.COVER;
    }

    @Override
    public int CONTAIN() {
        return this.CONTAIN;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$LEFT_$eq(int x$1) {
        this.LEFT = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$CENTER_$eq(int x$1) {
        this.CENTER = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$RIGHT_$eq(int x$1) {
        this.RIGHT = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$PLAYER_LOC_$eq(String x$1) {
        this.PLAYER_LOC = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$GOLD_$eq(String x$1) {
        this.GOLD = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$PLAYER_MOVEMENT_LOCKS_$eq(String x$1) {
        this.PLAYER_MOVEMENT_LOCKS = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$EVENTS_ENABLED_$eq(String x$1) {
        this.EVENTS_ENABLED = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$MENU_ENABLED_$eq(String x$1) {
        this.MENU_ENABLED = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$PARTY_$eq(String x$1) {
        this.PARTY = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$INVENTORY_ITEM_IDS_$eq(String x$1) {
        this.INVENTORY_ITEM_IDS = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$INVENTORY_QTYS_$eq(String x$1) {
        this.INVENTORY_QTYS = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$CHARACTER_NAMES_$eq(String x$1) {
        this.CHARACTER_NAMES = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$CHARACTER_LEVELS_$eq(String x$1) {
        this.CHARACTER_LEVELS = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$CHARACTER_HPS_$eq(String x$1) {
        this.CHARACTER_HPS = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$CHARACTER_MPS_$eq(String x$1) {
        this.CHARACTER_MPS = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$CHARACTER_EXPS_$eq(String x$1) {
        this.CHARACTER_EXPS = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$CHARACTER_ROWS_$eq(String x$1) {
        this.CHARACTER_ROWS = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$CENTERED_$eq(int x$1) {
        this.CENTERED = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$NORTH_$eq(int x$1) {
        this.NORTH = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$EAST_$eq(int x$1) {
        this.EAST = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$SOUTH_$eq(int x$1) {
        this.SOUTH = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$WEST_$eq(int x$1) {
        this.WEST = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$NORTHEAST_$eq(int x$1) {
        this.NORTHEAST = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$SOUTHEAST_$eq(int x$1) {
        this.SOUTHEAST = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$SOUTHWEST_$eq(int x$1) {
        this.SOUTHWEST = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$NORTHWEST_$eq(int x$1) {
        this.NORTHWEST = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$FIXED_$eq(int x$1) {
        this.FIXED = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$SCALE_SOURCE_$eq(int x$1) {
        this.SCALE_SOURCE = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$SCREEN_$eq(int x$1) {
        this.SCREEN = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$COVER_$eq(int x$1) {
        this.COVER = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$CONTAIN_$eq(int x$1) {
        this.CONTAIN = x$1;
    }

    @Override
    public String VEHICLE_LOC(int vehicleId) {
        return HasScriptConstants$class.VEHICLE_LOC(this, vehicleId);
    }

    @Override
    public String CHARACTER_EQUIP(int characterId) {
        return HasScriptConstants$class.CHARACTER_EQUIP(this, characterId);
    }

    @Override
    public String CHARACTER_STATUS_EFFECTS(int characterId) {
        return HasScriptConstants$class.CHARACTER_STATUS_EFFECTS(this, characterId);
    }

    @Override
    public String CHARACTER_LEARNED_SKILLS(int characterId) {
        return HasScriptConstants$class.CHARACTER_LEARNED_SKILLS(this, characterId);
    }

    @Override
    public ScriptInterface scriptInterface() {
        return this.scriptInterface;
    }

    @Override
    public ScriptThreadFactory scriptFactory() {
        return this.scriptFactory;
    }

    @Override
    public void rpgboss$player$RpgScreenWithGame$_setter_$scriptInterface_$eq(ScriptInterface x$1) {
        this.scriptInterface = x$1;
    }

    @Override
    public void rpgboss$player$RpgScreenWithGame$_setter_$scriptFactory_$eq(ScriptThreadFactory x$1) {
        this.scriptFactory = x$1;
    }

    @Override
    public Project project() {
        return RpgScreenWithGame$class.project(this);
    }

    @Override
    public int screenW() {
        return RpgScreenWithGame$class.screenW(this);
    }

    @Override
    public int screenH() {
        return RpgScreenWithGame$class.screenH(this);
    }

    @Override
    public RpgAssetManager assets() {
        return RpgScreenWithGame$class.assets(this);
    }

    @Override
    public boolean renderingOffForTesting() {
        return RpgScreenWithGame$class.renderingOffForTesting(this);
    }

    @Override
    public InputMultiplexer inputs() {
        return this.inputs;
    }

    @Override
    public Option<MusicPlayer>[] musics() {
        return this.musics;
    }

    @Override
    public SpriteBatch batch() {
        return this.batch;
    }

    @Override
    public ShapeRenderer shapeRenderer() {
        return this.shapeRenderer;
    }

    @Override
    public Set<MusicPlayer> oldMusics() {
        return this.oldMusics;
    }

    @Override
    public OrthographicCamera screenCamera() {
        return this.screenCamera;
    }

    @Override
    public WindowManager windowManager() {
        return this.windowManager;
    }

    @Override
    public ShakeManager shakeManager() {
        return this.shakeManager;
    }

    @Override
    public AnimationPlayer soundPlayer() {
        return this.soundPlayer;
    }

    @Override
    public void soundPlayer_$eq(AnimationPlayer x$1) {
        this.soundPlayer = x$1;
    }

    @Override
    public AnimationSound animationSound() {
        return this.animationSound;
    }

    @Override
    public void animationSound_$eq(AnimationSound x$1) {
        this.animationSound = x$1;
    }

    @Override
    public Animation animation() {
        return this.animation;
    }

    @Override
    public void animation_$eq(Animation x$1) {
        this.animation = x$1;
    }

    @Override
    public void rpgboss$player$RpgScreen$_setter_$inputs_$eq(InputMultiplexer x$1) {
        this.inputs = x$1;
    }

    @Override
    public void rpgboss$player$RpgScreen$_setter_$musics_$eq(Option[] x$1) {
        this.musics = x$1;
    }

    @Override
    public void rpgboss$player$RpgScreen$_setter_$batch_$eq(SpriteBatch x$1) {
        this.batch = x$1;
    }

    @Override
    public void rpgboss$player$RpgScreen$_setter_$shapeRenderer_$eq(ShapeRenderer x$1) {
        this.shapeRenderer = x$1;
    }

    @Override
    public void rpgboss$player$RpgScreen$_setter_$oldMusics_$eq(Set x$1) {
        this.oldMusics = x$1;
    }

    @Override
    public void rpgboss$player$RpgScreen$_setter_$screenCamera_$eq(OrthographicCamera x$1) {
        this.screenCamera = x$1;
    }

    @Override
    public void rpgboss$player$RpgScreen$_setter_$windowManager_$eq(WindowManager x$1) {
        this.windowManager = x$1;
    }

    @Override
    public void rpgboss$player$RpgScreen$_setter_$shakeManager_$eq(ShakeManager x$1) {
        this.shakeManager = x$1;
    }

    @Override
    public AnimationPlayer playAnimation(int animationId, AnimationTarget target, float speedScale, float sizeScale) {
        return RpgScreen$class.playAnimation(this, animationId, target, speedScale, sizeScale);
    }

    @Override
    public void playMusic(int slot, Option<SoundSpec> specOpt, boolean loop2, float fadeDuration) {
        RpgScreen$class.playMusic(this, slot, specOpt, loop2, fadeDuration);
    }

    @Override
    public void playSound(SoundSpec soundSpec) {
        RpgScreen$class.playSound(this, soundSpec);
    }

    @Override
    public void stopSound() {
        RpgScreen$class.stopSound(this);
    }

    @Override
    public void hide() {
        RpgScreen$class.hide(this);
    }

    @Override
    public void pause() {
        RpgScreen$class.pause(this);
    }

    @Override
    public void render(float delta) {
        RpgScreen$class.render(this, delta);
    }

    @Override
    public void resize(int width, int height) {
        RpgScreen$class.resize(this, width, height);
    }

    @Override
    public void resume() {
        RpgScreen$class.resume(this);
    }

    @Override
    public void show() {
        RpgScreen$class.show(this);
    }

    @Override
    public Thread rpgboss$lib$ThreadChecked$$_boundThread() {
        return this.rpgboss$lib$ThreadChecked$$_boundThread;
    }

    @Override
    public void rpgboss$lib$ThreadChecked$$_boundThread_$eq(Thread x$1) {
        this.rpgboss$lib$ThreadChecked$$_boundThread = x$1;
    }

    @Override
    public void rebindToCurrentThread() {
        ThreadChecked$class.rebindToCurrentThread(this);
    }

    @Override
    public void assertOnBoundThread() {
        ThreadChecked$class.assertOnBoundThread(this);
    }

    @Override
    public void assertOnDifferentThread() {
        ThreadChecked$class.assertOnDifferentThread(this);
    }

    @Override
    public boolean onBoundThread() {
        return ThreadChecked$class.onBoundThread(this);
    }

    @Override
    public RpgGame game() {
        return this.game;
    }

    public ScriptHookManager scriptHooks() {
        return this.scriptHooks;
    }

    public float screenWTiles() {
        return this.screenWTiles;
    }

    public void screenWTiles_$eq(float x$1) {
        this.screenWTiles = x$1;
    }

    public float screenHTiles() {
        return this.screenHTiles;
    }

    public void screenHTiles_$eq(float x$1) {
        this.screenHTiles = x$1;
    }

    public OrthographicCamera tileCamera() {
        return this.tileCamera;
    }

    public Option<MapAndAssets> mapAndAssetsOption() {
        return this.mapAndAssetsOption;
    }

    public void mapAndAssetsOption_$eq(Option<MapAndAssets> x$1) {
        this.mapAndAssetsOption = x$1;
    }

    public Option<String> mapName() {
        return this.mapAndAssetsOption().map(new Serializable(this){

            public final String apply(MapAndAssets x$1) {
                return x$1.map().name();
            }
        });
    }

    public PlayerEntity playerEntity() {
        return (PlayerEntity)this.allEntities().apply(BoxesRunTime.boxToInteger(EntitySpec$.MODULE$.playerEntityId()));
    }

    public EntityInfo getPlayerEntityInfo() {
        return EntityInfo$.MODULE$.apply(this.playerEntity(), this);
    }

    public EntityMove movePlayer(float dx, float dy, boolean affixDirection) {
        this.assertOnBoundThread();
        return this.playerEntity().moveEntity(new Vector2(dx, dy), affixDirection);
    }

    public EntityMove moveEvent(int id, float dx, float dy, boolean affixDirection) {
        this.assertOnBoundThread();
        Option<EntityMove> entityOpt = this.allEntities().get(BoxesRunTime.boxToInteger(id));
        return (EntityMove)entityOpt.map(new Serializable(this, dx, dy, affixDirection){
            private final float dx$1;
            private final float dy$1;
            private final boolean affixDirection$1;

            public final EntityMove apply(Entity entity) {
                return entity.moveEntity(new Vector2(this.dx$1, this.dy$1), this.affixDirection$1);
            }
            {
                this.dx$1 = dx$1;
                this.dy$1 = dy$1;
                this.affixDirection$1 = affixDirection$1;
            }
        }).orNull(Predef$.MODULE$.$conforms());
    }

    public float getEventX(int id) {
        Object object = new Object();
        try {
            Option<Nothing$> entityOpt = this.allEntities().get(BoxesRunTime.boxToInteger(id));
            entityOpt.map(new Serializable(this, object){
                private final Object nonLocalReturnKey1$1;

                public final Nothing$ apply(Entity entity) {
                    throw new NonLocalReturnControl$mcF$sp(this.nonLocalReturnKey1$1, entity.x());
                }
                {
                    this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                }
            }).orNull(Predef$.MODULE$.$conforms());
            return 0.0f;
        }
        catch (NonLocalReturnControl nonLocalReturnControl) {
            if (nonLocalReturnControl.key() == object) {
                return nonLocalReturnControl.value$mcF$sp();
            }
            throw nonLocalReturnControl;
        }
    }

    public float getEventY(int id) {
        Object object = new Object();
        try {
            Option<Nothing$> entityOpt = this.allEntities().get(BoxesRunTime.boxToInteger(id));
            entityOpt.map(new Serializable(this, object){
                private final Object nonLocalReturnKey2$1;

                public final Nothing$ apply(Entity entity) {
                    throw new NonLocalReturnControl$mcF$sp(this.nonLocalReturnKey2$1, entity.y());
                }
                {
                    this.nonLocalReturnKey2$1 = nonLocalReturnKey2$1;
                }
            }).orNull(Predef$.MODULE$.$conforms());
            return 0.0f;
        }
        catch (NonLocalReturnControl nonLocalReturnControl) {
            if (nonLocalReturnControl.key() == object) {
                return nonLocalReturnControl.value$mcF$sp();
            }
            throw nonLocalReturnControl;
        }
    }

    public void setCameraFollow(Option<Object> entityId) {
        this.cameraFollowedEntity_$eq(entityId.flatMap(new Serializable(this){
            private final /* synthetic */ MapScreen $outer;

            public final Option<Entity> apply(int key) {
                return this.$outer.allEntities().get(BoxesRunTime.boxToInteger(key));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
    }

    public MapCamera camera() {
        return this.camera;
    }

    public Map<Object, Entity> allEntities() {
        return this.allEntities;
    }

    public Option<Entity> cameraFollowedEntity() {
        return this.cameraFollowedEntity;
    }

    public void cameraFollowedEntity_$eq(Option<Entity> x$1) {
        this.cameraFollowedEntity = x$1;
    }

    public void setPlayerLoc(MapLoc loc) {
        this.mapAndAssetsOption().map(new Serializable(this){

            public final void apply(MapAndAssets x$2) {
                x$2.dispose();
            }
        });
        this.mapAndAssetsOption_$eq(None$.MODULE$);
        this.allEntities().map((Function1<Object, Entity>)((Object)new Serializable(this){

            public final void apply(Tuple2<Object, Entity> x$3) {
                x$3._2().dispose();
            }
        }), Iterable$.MODULE$.canBuildFrom());
        this.allEntities().clear();
        if (loc.map().isEmpty()) {
            return;
        }
        String mapName2 = loc.map();
        MapAndAssets mapAndAssets = new MapAndAssets(this.project(), loc.map(), this.renderingOffForTesting());
        mapAndAssets.setLastBattlePosition(loc.x(), loc.y());
        this.mapAndAssetsOption_$eq(new Some<MapAndAssets>(mapAndAssets));
        this.windowManager().reset();
        HashSet distinctChars2 = (HashSet)this.project().data().enums().distinctChars().$plus$plus((GenTraversableOnce)mapAndAssets.mapData().distinctChars());
        this.windowManager().updateBitmapFont(distinctChars2.mkString());
        this.allEntities().update(BoxesRunTime.boxToInteger(EntitySpec$.MODULE$.playerEntityId()), new PlayerEntity(this.game(), this));
        this.playerEntity().x_$eq(loc.x());
        this.playerEntity().y_$eq(loc.y());
        this.playerEntity().mapName_$eq(new Some<String>(loc.map()));
        this.playerEntity().updateSprite();
        this.allEntities().$plus$plus$eq(mapAndAssets.mapData().events().map((Function1<Object, RpgEvent>)((Object)new Serializable(this, mapName2){
            private final /* synthetic */ MapScreen $outer;
            private final String mapName$1;

            public final Tuple2<Object, EventEntity> apply(Tuple2<Object, RpgEvent> x0$1) {
                Tuple2<Object, RpgEvent> tuple2 = x0$1;
                if (tuple2 != null) {
                    int k = tuple2._1$mcI$sp();
                    RpgEvent v = tuple2._2();
                    Tuple2<Object, EventEntity> tuple22 = new Tuple2<Object, EventEntity>(BoxesRunTime.boxToInteger(k), new EventEntity(this.$outer.game().project(), this.$outer.game().persistent(), this.$outer.scriptInterface(), this.$outer.scriptFactory(), this.$outer.game().spritesets(), this.$outer.mapAndAssetsOption(), this.$outer.allEntities(), this.mapName$1, v));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.mapName$1 = mapName$1;
            }
        }), scala.collection.immutable.Map$.MODULE$.canBuildFrom()));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), Constants$.MODULE$.NUM_VEHICLES()).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new Serializable(this, mapName2){
            private final /* synthetic */ MapScreen $outer;
            private final String mapName$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                MapLoc loc = this.$outer.game().persistent().getLoc(this.$outer.VEHICLE_LOC(i));
                String string2 = loc.map();
                String string3 = this.mapName$1;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    this.$outer.insertVehicleEntity(i, loc);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.mapName$1 = mapName$1;
            }
        }));
        this.cameraFollowedEntity_$eq(new Some<Entity>(this.playerEntity()));
        this.playMusic(0, mapAndAssets.map().metadata().music(), true, Transitions$.MODULE$.fadeLength());
        this.updateCameraLoc(0.0f, mapAndAssets, true);
        int interiorValue = 0;
        if (mapAndAssets.map().metadata().interior()) {
            interiorValue = 1;
        }
        this.scriptInterface().setInt("interior", interiorValue);
    }

    public void persistPlayerLocation() {
        PlayerEntity p = this.playerEntity();
        Predef$.MODULE$.assert(p.mapName().isDefined());
        this.game().persistent().setLoc(this.PLAYER_LOC(), new MapLoc(p.mapName().get(), p.x(), p.y()));
    }

    public void insertVehicleEntity(int vehicleId, MapLoc loc) {
        String string2 = loc.map();
        String string3 = this.mapAndAssetsOption().get().mapName();
        Predef$.MODULE$.assert(!(string2 != null ? !string2.equals(string3) : string3 != null));
        VehicleEntity vehicleEntity = new VehicleEntity(this.game(), vehicleId);
        this.allEntities().update(BoxesRunTime.boxToInteger(EntitySpec$.MODULE$.vehicleEntityId(vehicleId)), vehicleEntity);
        vehicleEntity.x_$eq(loc.x());
        vehicleEntity.y_$eq(loc.y());
    }

    public void updateCameraLoc(float delta, MapAndAssets mapAndAssets, boolean forceSnapToEntity) {
        RpgMap map2 = mapAndAssets.map();
        this.camera().update(delta, this.cameraFollowedEntity(), forceSnapToEntity, map2.metadata(), this.screenWTiles(), this.screenHTiles());
        this.tileCamera().position.x = this.camera().x() + this.shakeManager().xDisplacement() / (float)Tileset$.MODULE$.tilesize();
        this.tileCamera().position.y = this.camera().y() + this.shakeManager().yDisplacement() / (float)Tileset$.MODULE$.tilesize();
        this.tileCamera().update();
    }

    public Object drawTile(SpriteBatch batch, MapAndAssets mapAndAssets, float whereInSecond, int tileX, int tileY, byte byte1, byte byte2, byte byte3) {
        Object object;
        if (byte1 < 0) {
            if (byte1 == RpgMap$.MODULE$.autotileByte()) {
                Autotile autotile = mapAndAssets.autotiles()[byte2];
                TextureAtlas.AtlasRegion region = mapAndAssets.atlasTiles().findRegion(new StringOps(Predef$.MODULE$.augmentString("autotile/%s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{autotile.name()})));
                int frameIdx = (int)(whereInSecond * (float)autotile.frames());
                Tuple2<Tuple2<Object, Object>, Tuple2<Object, Object>>[] srcDestPositions = autotile.getHalfTiles(byte3, frameIdx);
                object = Predef$.MODULE$.refArrayOps((Object[])srcDestPositions).map(new Serializable(this, batch, tileX, tileY, region){
                    private final SpriteBatch batch$1;
                    private final int tileX$1;
                    private final int tileY$1;
                    private final TextureAtlas.AtlasRegion region$1;

                    public final void apply(Tuple2<Tuple2<Object, Object>, Tuple2<Object, Object>> x0$2) {
                        Tuple2<Tuple2<Object, Object>, Tuple2<Object, Object>> tuple2 = x0$2;
                        if (tuple2 != null) {
                            Tuple2<Object, Object> tuple22 = tuple2._1();
                            Tuple2<Object, Object> tuple23 = tuple2._2();
                            if (tuple22 != null) {
                                int srcXHt = tuple22._1$mcI$sp();
                                int srcYHt = tuple22._2$mcI$sp();
                                if (tuple23 != null) {
                                    int dstXHt = tuple23._1$mcI$sp();
                                    int dstYHt = tuple23._2$mcI$sp();
                                    this.batch$1.draw(this.region$1.getTexture(), (float)this.tileX$1 + (float)dstXHt * 0.5f, (float)this.tileY$1 + (float)dstYHt * 0.5f, 0.5f, 0.5f, this.region$1.getRegionX() + srcXHt * Tileset$.MODULE$.halftile(), this.region$1.getRegionY() + srcYHt * Tileset$.MODULE$.halftile(), Tileset$.MODULE$.halftile(), Tileset$.MODULE$.halftile(), false, true);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                            }
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.batch$1 = batch$1;
                        this.tileX$1 = tileX$1;
                        this.tileY$1 = tileY$1;
                        this.region$1 = region$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Unit()));
            } else {
                object = BoxedUnit.UNIT;
            }
        } else {
            Tileset tileset = mapAndAssets.tilesets()[byte1];
            TextureAtlas.AtlasRegion region = mapAndAssets.atlasTiles().findRegion(new StringOps(Predef$.MODULE$.augmentString("tileset/%s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{tileset.name()})));
            batch.draw(region.getTexture(), (float)tileX, (float)tileY, 1.0f, 1.0f, region.getRegionX() + byte2 * Tileset$.MODULE$.tilesize(), region.getRegionY() + byte3 * Tileset$.MODULE$.tilesize(), Tileset$.MODULE$.tilesize(), Tileset$.MODULE$.tilesize(), false, true);
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    @Override
    public void update(float delta) {
        if (this.windowManager().inTransition()) {
            return;
        }
        this.scriptHooks().update(delta);
        float playerOldX = this.playerEntity().x();
        float playerOldY = this.playerEntity().y();
        boolean eventsEnabled = this.game().persistent().getInt(this.EVENTS_ENABLED()) != 0;
        this.allEntities().values().foreach(new Serializable(this, delta, eventsEnabled){
            private final float delta$1;
            private final boolean eventsEnabled$1;

            public final void apply(Entity x$4) {
                x$4.update(this.delta$1, this.eventsEnabled$1);
            }
            {
                this.delta$1 = delta$1;
                this.eventsEnabled$1 = eventsEnabled$1;
            }
        });
        float playerMoveDistance = package$.MODULE$.abs(this.playerEntity().x() - playerOldX) + package$.MODULE$.abs(this.playerEntity().y() - playerOldY);
        this.mapAndAssetsOption().map(new Serializable(this, delta, playerMoveDistance){
            private final /* synthetic */ MapScreen $outer;
            private final float delta$1;
            private final float playerMoveDistance$1;

            public final void apply(MapAndAssets mapAndAssets) {
                this.$outer.updateCameraLoc(this.delta$1, mapAndAssets, false);
                int minimumDistanceFromLastBattle = 3;
                RandomEncounterSettings encounterSettings = mapAndAssets.randomEncounterSettings();
                RpgMapMetadata mapMetadata = mapAndAssets.map().metadata();
                float distFromLastBattle = mapAndAssets.manhattanDistanceFromLastBattle(this.$outer.playerEntity().x(), this.$outer.playerEntity().y());
                if (!Predef$.MODULE$.refArrayOps((Object[])encounterSettings.encounters()).isEmpty() && distFromLastBattle > (float)minimumDistanceFromLastBattle) {
                    float chanceBattle = this.playerMoveDistance$1 / (float)encounterSettings.stepsAverage();
                    if (package$.MODULE$.random() < (double)chanceBattle) {
                        mapAndAssets.setLastBattlePosition(this.$outer.playerEntity().x(), this.$outer.playerEntity().y());
                        int encounterId = BoxesRunTime.unboxToInt(Utils$.MODULE$.randomChoose(Predef$.MODULE$.refArrayOps((Object[])encounterSettings.encounters()).map(new Serializable(this){

                            public final int apply(RandomEncounter x$5) {
                                return x$5.encounterId();
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())), (float[])Predef$.MODULE$.refArrayOps((Object[])encounterSettings.encounters()).map(new Serializable(this){

                            public final float apply(RandomEncounter x$6) {
                                return Predef$.MODULE$.int2Integer(x$6.weight()).floatValue();
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()))));
                        this.$outer.game().startBattle(encounterId);
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.delta$1 = delta$1;
                this.playerMoveDistance$1 = playerMoveDistance$1;
            }
        });
    }

    public Option<BoxedUnit> renderMap() {
        return this.mapAndAssetsOption().map(new Serializable(this){
            private final /* synthetic */ MapScreen $outer;

            public final void apply(MapAndAssets mapAndAssets) {
                this.$outer.batch().setProjectionMatrix(this.$outer.tileCamera().combined);
                float cameraL = this.$outer.camera().x() - this.$outer.screenWTiles() / (float)2;
                float cameraR = this.$outer.camera().x() + this.$outer.screenWTiles() / (float)2;
                float cameraT = this.$outer.camera().y() - this.$outer.screenHTiles() / (float)2;
                float cameraB = this.$outer.camera().y() + this.$outer.screenHTiles() / (float)2;
                int tileL = package$.MODULE$.max(0, (int)cameraL);
                int tileR = package$.MODULE$.min(mapAndAssets.map().metadata().xSize() - 1, (int)cameraR + 1);
                int tileT = package$.MODULE$.max(0, (int)cameraT);
                int tileB = package$.MODULE$.min(mapAndAssets.map().metadata().ySize() - 1, (int)cameraB + 1);
                float whereInSecond = (float)(System.currentTimeMillis() % 1000L) / 1000.0f;
                this.$outer.batch().begin();
                ((List)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new byte[][][]{mapAndAssets.mapData().botLayer(), mapAndAssets.mapData().midLayer(), mapAndAssets.mapData().topLayer()}))).foreach(new Serializable(this, tileL, tileR, tileT, tileB, whereInSecond, mapAndAssets){
                    private final /* synthetic */ $anonfun$renderMap$1 $outer;
                    public final int tileL$1;
                    public final int tileR$1;
                    private final int tileT$1;
                    private final int tileB$1;
                    public final float whereInSecond$1;
                    public final MapAndAssets mapAndAssets$1;

                    public final void apply(byte[][] layerAry) {
                        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(this.tileT$1), this.tileB$1).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new Serializable(this, layerAry){
                            private final /* synthetic */ $anonfun$renderMap$1$$anonfun$apply$2 $outer;
                            private final byte[][] layerAry$1;

                            public final void apply(int tileY) {
                                this.apply$mcVI$sp(tileY);
                            }

                            public void apply$mcVI$sp(int tileY) {
                                byte[] row = this.layerAry$1[tileY];
                                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(this.$outer.tileL$1), this.$outer.tileR$1).foreach(new Serializable(this, row, tileY){
                                    private final /* synthetic */ $anonfun$renderMap$1$$anonfun$apply$2$$anonfun$apply$1 $outer;
                                    private final byte[] row$1;
                                    private final int tileY$2;

                                    public final Object apply(int tileX) {
                                        int idx = tileX * RpgMap$.MODULE$.bytesPerTile();
                                        byte byte1 = this.row$1[idx];
                                        byte byte2 = this.row$1[idx + 1];
                                        byte byte3 = this.row$1[idx + 2];
                                        return this.$outer.rpgboss$player$MapScreen$$anonfun$$anonfun$$anonfun$$$outer().rpgboss$player$MapScreen$$anonfun$$anonfun$$$outer().rpgboss$player$MapScreen$$anonfun$$$outer().drawTile(this.$outer.rpgboss$player$MapScreen$$anonfun$$anonfun$$anonfun$$$outer().rpgboss$player$MapScreen$$anonfun$$anonfun$$$outer().rpgboss$player$MapScreen$$anonfun$$$outer().batch(), this.$outer.rpgboss$player$MapScreen$$anonfun$$anonfun$$anonfun$$$outer().mapAndAssets$1, this.$outer.rpgboss$player$MapScreen$$anonfun$$anonfun$$anonfun$$$outer().whereInSecond$1, tileX, this.tileY$2, byte1, byte2, byte3);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.row$1 = row$1;
                                        this.tileY$2 = tileY$2;
                                    }
                                });
                            }

                            public /* synthetic */ $anonfun$renderMap$1$$anonfun$apply$2 rpgboss$player$MapScreen$$anonfun$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.layerAry$1 = layerAry$1;
                            }
                        }));
                    }

                    public /* synthetic */ $anonfun$renderMap$1 rpgboss$player$MapScreen$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.tileL$1 = tileL$1;
                        this.tileR$1 = tileR$1;
                        this.tileT$1 = tileT$1;
                        this.tileB$1 = tileB$1;
                        this.whereInSecond$1 = whereInSecond$1;
                        this.mapAndAssets$1 = mapAndAssets$1;
                    }
                });
                Entity[] zSortedEntities = (Entity[])((TraversableOnce)((SeqLike)this.$outer.allEntities().values().toList().filter((Function1)((Object)new Serializable(this, cameraL, cameraR, cameraT, cameraB){
                    private final float cameraL$1;
                    private final float cameraR$1;
                    private final float cameraT$1;
                    private final float cameraB$1;

                    public final boolean apply(Entity e) {
                        return e.x() >= this.cameraL$1 - (float)2 && e.x() <= this.cameraR$1 + (float)2 && e.y() >= this.cameraT$1 - (float)2 && e.y() <= this.cameraB$1 + (float)2;
                    }
                    {
                        this.cameraL$1 = cameraL$1;
                        this.cameraR$1 = cameraR$1;
                        this.cameraT$1 = cameraT$1;
                        this.cameraB$1 = cameraB$1;
                    }
                }))).sortBy(new Serializable(this){

                    public final float apply(Entity x$7) {
                        return x$7.zPriority();
                    }
                }, Ordering$Float$.MODULE$)).toArray(ClassTag$.MODULE$.apply(Entity.class));
                int entityI = 0;
                int tileI = 0;
                while (entityI < Predef$.MODULE$.refArrayOps((Object[])zSortedEntities).size() || tileI < Predef$.MODULE$.refArrayOps((Object[])this.tiles$1(mapAndAssets)).size()) {
                    if (tileI == Predef$.MODULE$.refArrayOps((Object[])this.tiles$1(mapAndAssets)).size() || entityI < Predef$.MODULE$.refArrayOps((Object[])zSortedEntities).size() && zSortedEntities[entityI].y() < (float)this.tiles$1(mapAndAssets)[tileI].zPriority()) {
                        zSortedEntities[entityI].render(this.$outer.batch(), this.$outer.game().atlasSprites());
                        ++entityI;
                        continue;
                    }
                    MapAndAssets.ElevatedTile tile = this.tiles$1(mapAndAssets)[tileI];
                    Object object = (float)tile.tileX() >= cameraL - (float)2 && (float)tile.tileX() <= cameraR + (float)2 && (float)tile.tileY() >= cameraT - (float)2 && (float)tile.tileY() <= cameraB + (float)2 ? this.$outer.drawTile(this.$outer.batch(), mapAndAssets, whereInSecond, tile.tileX(), tile.tileY(), tile.byte1(), tile.byte2(), tile.byte3()) : BoxedUnit.UNIT;
                    ++tileI;
                }
                this.$outer.batch().end();
            }

            public /* synthetic */ MapScreen rpgboss$player$MapScreen$$anonfun$$$outer() {
                return this.$outer;
            }

            private final MapAndAssets.ElevatedTile[] tiles$1(MapAndAssets mapAndAssets$1) {
                return mapAndAssets$1.elevatedTiles();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public void render() {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        Gdx.gl.glEnable(3042);
        this.windowManager().preMapRender(this.batch(), this.screenCamera());
        this.renderMap();
        this.windowManager().render(this.batch(), this.shapeRenderer(), this.screenCamera());
    }

    @Override
    public void dispose() {
        this.mapAndAssetsOption().map(new Serializable(this){

            public final void apply(MapAndAssets x$8) {
                x$8.dispose();
            }
        });
        RpgScreen$class.dispose(this);
    }

    @Override
    public void reset() {
        RpgScreen$class.reset(this);
        this.setPlayerLoc(new MapLoc(MapLoc$.MODULE$.apply$default$1(), MapLoc$.MODULE$.apply$default$2(), MapLoc$.MODULE$.apply$default$3()));
    }

    public MapScreen(RpgGame game) {
        this.game = game;
        ThreadChecked$class.$init$(this);
        RpgScreen$class.$init$(this);
        RpgScreenWithGame$class.$init$(this);
        HasScriptConstants$class.$init$(this);
        this.scriptHooks = new ScriptHookManager(this.scriptInterface());
        this.screenWTiles = this.screenW() / Tileset$.MODULE$.tilesize();
        this.screenHTiles = this.screenH() / Tileset$.MODULE$.tilesize();
        this.tileCamera = new OrthographicCamera();
        this.tileCamera().setToOrtho(true, this.screenWTiles(), this.screenHTiles());
        this.mapAndAssetsOption = None$.MODULE$;
        this.camera = new MapCamera();
        this.allEntities = (Map)Map$.MODULE$.apply(Nil$.MODULE$);
        this.cameraFollowedEntity = None$.MODULE$;
    }
}

